// offscreen.js
chrome.runtime.onMessage.addListener(handleMessages);

async function handleMessages(message) {
  if (message.target !== 'offscreen-doc') return;

  if (message.type === 'copy-data-to-clipboard') {
    const text = message.data;

    // --- 方案 A: 优先尝试现代 API ---
    try {
      if (navigator.clipboard && navigator.clipboard.writeText) {
        await navigator.clipboard.writeText(text);
        return; 
      }
    } catch (err) {

    }

   
    try {
      const textArea = document.createElement('textarea');
      
      // 样式：透明且对布局无影响
      textArea.style.position = 'fixed';
      textArea.style.left = '0';
      textArea.style.top = '0';
      textArea.style.width = '1px';
      textArea.style.height = '1px';
      textArea.style.opacity = '0';
      textArea.style.border = 'none';
      textArea.style.outline = 'none';
      textArea.style.background = 'transparent';
      
      textArea.value = text;
      
      document.body.appendChild(textArea);
      
      // macOS 核心步骤：聚焦 -> 清除选区 -> 全选
      textArea.focus();
      const selection = window.getSelection();
      selection.removeAllRanges(); 
      textArea.select();
      
      // 执行复制
      document.execCommand('copy');
      
      // 清理 DOM
      document.body.removeChild(textArea);
      

    } catch (err) {      
       console.error(err); 
    }
  }
}