const API_BASE = 'https://123share.cn'; // 你的服务器地址

// Tab 切换逻辑
document.querySelectorAll('.tab').forEach(tab => {
  tab.addEventListener('click', () => {
    document.querySelectorAll('.tab').forEach(t => t.classList.remove('active'));
    document.querySelectorAll('.panel').forEach(p => p.classList.remove('active'));
    tab.classList.add('active');
    document.getElementById(tab.dataset.target).classList.add('active');
  });
});

// === 发送逻辑 ===
document.getElementById('btn-send').addEventListener('click', async () => {
  const text = document.getElementById('text-input').value.trim();
  if (!text) return alert('请输入内容');
  
  await sendText(text);
});

// 发送当前网址
document.getElementById('btn-send-url').addEventListener('click', () => {
  // 获取当前激活 Tab 的 URL
  chrome.tabs.query({ active: true, currentWindow: true }, (tabs) => {
    const url = tabs[0].url;
    document.getElementById('text-input').value = url;
    sendText(url);
  });
});

async function sendText(content) {
  const btn = document.getElementById('btn-send');
  btn.innerText = '生成中...';
  
  try {
    const res = await fetch(`${API_BASE}/api/share/text`, {
      method: 'POST',
      headers: { 'Content-Type': 'application/json' },
      body: JSON.stringify({ text: content, burn: false })
    });
    const data = await res.json();
    
    if (data.code) {
      document.getElementById('send-result').classList.remove('hidden');
      document.getElementById('send-code').innerText = data.code;
      // 自动复制
      navigator.clipboard.writeText(data.code);
    } else {
      alert('发送失败: ' + (data.error || '未知错误'));
    }
  } catch (err) {
    alert('网络错误');
  } finally {
    btn.innerText = '生成取件码';
  }
}

// === 接收逻辑 ===
document.getElementById('btn-receive').addEventListener('click', async () => {
  const code = document.getElementById('code-input').value.trim();
  if (code.length !== 4) return alert('请输入4位取件码');
  
  const btn = document.getElementById('btn-receive');
  btn.innerText = '查询中...';
  
  try {
    const res = await fetch(`${API_BASE}/api/get/${code}`);
    const data = await res.json();
    
    if (data.error) {
      alert(data.error);
    } else if (data.type === 'text') {
      document.getElementById('receive-result').classList.remove('hidden');
      document.getElementById('receive-content').value = data.content;
    } else if (data.type === 'file') {
      // 如果是文件，直接打开下载链接
      chrome.tabs.create({ url: data.downloadUrl });
    }
  } catch (err) {
    alert('查询失败');
  } finally {
    btn.innerText = '立即提取';
  }
});

// 复制接收到的文本
document.getElementById('btn-copy-receive').addEventListener('click', () => {
  const text = document.getElementById('receive-content').value;
  navigator.clipboard.writeText(text);
  alert('已复制');
});